/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscriptionMgrFactory;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.hsc.common.util.PartitionInfo;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.sfp.surveillance.Surveillance;
import com.ibm.hsc.sfp.surveillance.SurveillanceCimomListener;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventList;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionConnectionState;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionState;
import java.net.InetAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.UnsignedInt8;

public class SurveillancePartitionStateList {
    private static final String TRACE_MASKD = "JSURVPSD";
    private static final String TRACE_MASKF = "JSURVPSF";
    private static final String TRACE_MASKT = "JSURVPST";
    private static final String NO_CONNECT_SRC = "B302000100000070";
    private Hashtable partitionStates = new Hashtable();
    private Surveillance surveillance = null;
    private SurveillanceCimomListener cimomListener = null;
    private HSCSubscriptionMgr subscription = null;
    private int lparAddSubscriptionId = 0;
    private int lparDeleteSubscriptionId = 0;
    private int lparModifySubscriptionId = 0;
    private int lparRestoreSubscriptionId = 0;

    SurveillancePartitionStateList(Surveillance surveillance) {
        this.doDebug("partition states are now (due to constructor) : ");
        this.surveillance = surveillance;
    }

    public static void main(String[] stringArray) {
        SurveillancePartitionStateList surveillancePartitionStateList = null;
        System.out.println("Creating partition state list");
        surveillancePartitionStateList = new SurveillancePartitionStateList(null);
        System.out.println("Subscribing for CIM updates");
        surveillancePartitionStateList.subscribeForCIMEvents(null);
        System.out.println("Updating CIM information");
        surveillancePartitionStateList.updateCIMInfo(null);
        System.out.println(surveillancePartitionStateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCIMInfo(SurveillanceEventList surveillanceEventList) {
        Hashtable hashtable = null;
        PartitionInfo partitionInfo = null;
        SurveillancePartitionState surveillancePartitionState = null;
        Map.Entry entry = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Trace.trace(TRACE_MASKT, "-> updateCIMInfo(...)");
        try {
            hashtable = CIMUtils.getPartitionInfo();
        }
        catch (CIMException cIMException) {
            Trace.trace(TRACE_MASKF, "Error getting partition information : " + cIMException.toString());
        }
        if (hashtable != null) {
            SurveillanceEventList surveillanceEventList2 = surveillanceEventList;
            synchronized (surveillanceEventList2) {
                SurveillancePartitionStateList surveillancePartitionStateList = this;
                synchronized (surveillancePartitionStateList) {
                    Iterator iterator = hashtable.entrySet().iterator();
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        partitionInfo = (PartitionInfo)entry.getValue();
                        string = partitionInfo.getName();
                        surveillancePartitionState = (SurveillancePartitionState)this.partitionStates.get(string);
                        if (surveillancePartitionState != null) {
                            try {
                                if (surveillancePartitionState.isRunning() && (partitionInfo.getState() == null || partitionInfo.getState().intValue() != 8)) {
                                    Trace.trace(TRACE_MASKD, "Partition now not running: " + partitionInfo);
                                    surveillanceEventList.updateNotRunning(SurveillancePartitionStateList.getCECMTM(string), SurveillancePartitionStateList.getCECMS(string), SurveillancePartitionStateList.getSlotId(string));
                                }
                            }
                            catch (CIMException cIMException) {
                                // empty catch block
                            }
                            surveillancePartitionState.setCIMInfo(partitionInfo);
                        } else {
                            surveillancePartitionState = new SurveillancePartitionState(partitionInfo.getState(), partitionInfo.getSurveillanceSetting(), null, null, partitionInfo.getIsInPartitionMode(), partitionInfo.getUserName());
                            this.partitionStates.put(partitionInfo.getName(), surveillancePartitionState);
                            this.doDebug("partition states are now : ");
                        }
                        if (surveillanceEventList == null || surveillancePartitionState.hasBeenConnected() || surveillancePartitionState.getHasQueuedNYC()) continue;
                        bl = false;
                        try {
                            bl = surveillancePartitionState.isRunning();
                        }
                        catch (CIMException cIMException) {
                            // empty catch block
                        }
                        if (!bl) continue;
                        Trace.trace(TRACE_MASKD, "Processing partition named : " + string);
                        string2 = SurveillancePartitionStateList.getCECMTM(string);
                        string3 = SurveillancePartitionStateList.getCECMS(string);
                        try {
                            string4 = CIMUtils.getHMCMTM(string2, string3);
                        }
                        catch (CIMException cIMException) {
                            new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 4, cIMException).writeEntry(null);
                            string4 = "";
                        }
                        try {
                            string5 = CIMUtils.getHMCMS(string2, string3);
                        }
                        catch (CIMException cIMException) {
                            new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 5, cIMException).writeEntry(null);
                            string5 = "";
                        }
                        surveillanceEventList.addIfNotAlready(new SurveillanceEvent(SurveillancePartitionStateList.getSlotId(string), partitionInfo.getUserName(), "", new Date(), SurveillanceEventType.NOT_YET_CONNECTED, string2, string3, NO_CONNECT_SRC, string4, string5), 1800000L + this.surveillance.getConnectTimerInMS());
                        surveillancePartitionState.setHasQueuedNYC(true);
                    }
                    Iterator iterator2 = this.partitionStates.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        entry = iterator2.next();
                        string = (String)entry.getKey();
                        partitionInfo = (PartitionInfo)hashtable.get(string);
                        if (partitionInfo != null) continue;
                        iterator2.remove();
                        if (surveillanceEventList == null) continue;
                        surveillanceEventList.delete(SurveillancePartitionStateList.getCECMTM(string), SurveillancePartitionStateList.getCECMS(string), SurveillancePartitionStateList.getSlotId(string), SurveillanceEventType.NOT_YET_CONNECTED);
                    }
                }
            }
        }
        this.doDebug("partition states are now (after update) : ");
        Trace.trace(TRACE_MASKT, "<- updateCIMInfo(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Map.Entry entry = null;
        String string = null;
        SurveillancePartitionState surveillancePartitionState = null;
        SurveillancePartitionStateList surveillancePartitionStateList = this;
        synchronized (surveillancePartitionStateList) {
            stringBuffer.append("partitionStates = (");
            Iterator iterator = this.partitionStates.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = (String)entry.getKey();
                surveillancePartitionState = (SurveillancePartitionState)entry.getValue();
                stringBuffer.append("(" + string + ", " + ((Object)surveillancePartitionState).toString() + "),");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    synchronized SurveillancePartitionConnectionState getStableConnectionState(String string, String string2, String string3) {
        SurveillancePartitionState surveillancePartitionState = null;
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState != null) {
            return surveillancePartitionState.getStableConnectionState();
        }
        return null;
    }

    synchronized void setStableConnectionState(String string, String string2, String string3, SurveillancePartitionConnectionState surveillancePartitionConnectionState) {
        SurveillancePartitionState surveillancePartitionState = null;
        Trace.trace(TRACE_MASKT, "-> setStableConnectionState(" + string + ", " + string2 + ", " + string3 + ", " + surveillancePartitionConnectionState + ")");
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState == null) {
            surveillancePartitionState = new SurveillancePartitionState(surveillancePartitionConnectionState, null);
            this.partitionStates.put(SurveillancePartitionStateList.makePartitionName(string, string2, string3), surveillancePartitionState);
            this.doDebug("partition states are now : ");
        } else {
            surveillancePartitionState.setStableConnectionState(surveillancePartitionConnectionState);
        }
        Trace.trace(TRACE_MASKT, "<- setStableConnectionState(...)");
    }

    synchronized UnsignedInt8 getCIMState(String string, String string2, String string3) {
        SurveillancePartitionState surveillancePartitionState = null;
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState != null) {
            return surveillancePartitionState.getCIMState();
        }
        return null;
    }

    static String makePartitionName(String string, String string2, String string3) {
        return string3 + '*' + string + '*' + string2;
    }

    static String getSlotId(String string) {
        int n = 0;
        if (string != null && (n = string.indexOf(42)) != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    static String getCECMTM(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string != null && (n = string.indexOf(42)) != -1 && string.length() > n + 1 && (n2 = string.indexOf(42, n + 1)) != -1) {
            string2 = string.substring(n + 1, n2);
        }
        return string2;
    }

    static String getCECMS(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string != null && (n = string.indexOf(42)) != -1 && string.length() > n + 1 && (n2 = string.indexOf(42, n + 1)) != -1 && string.length() > n2 + 1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    synchronized SurveillancePartitionState get(String string, String string2, String string3) {
        if (this.partitionStates != null) {
            return (SurveillancePartitionState)this.partitionStates.get(SurveillancePartitionStateList.makePartitionName(string, string2, string3));
        }
        return null;
    }

    synchronized SurveillanceEventType getLastEventType(String string, String string2, String string3) {
        SurveillancePartitionState surveillancePartitionState = null;
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState != null) {
            return surveillancePartitionState.getLastEventType();
        }
        return null;
    }

    synchronized void setLastEventType(String string, String string2, String string3, SurveillanceEventType surveillanceEventType) {
        SurveillancePartitionState surveillancePartitionState = null;
        Trace.trace(TRACE_MASKT, "-> setLastEventType(" + string + ", " + string2 + ", " + string3 + ", " + surveillanceEventType + ")");
        surveillancePartitionState = this.get(string, string2, string3);
        if (surveillancePartitionState == null) {
            surveillancePartitionState = new SurveillancePartitionState(null, surveillanceEventType);
            this.partitionStates.put(SurveillancePartitionStateList.makePartitionName(string, string2, string3), surveillancePartitionState);
            this.doDebug("partition states are now : ");
        } else {
            surveillancePartitionState.setLastEventType(surveillanceEventType);
        }
        Trace.trace(TRACE_MASKT, "<- setLastEventType(...)");
    }

    void doDebug(String string) {
        String string2 = null;
        int n = 0;
        Trace.trace(TRACE_MASKD, string);
        string2 = this.toString();
        n = string2.length();
        int n2 = 0;
        while (n2 < string2.length()) {
            if (n2 + 80 >= n) {
                Trace.trace(TRACE_MASKD, string2.substring(n2, n));
                return;
            }
            Trace.trace(TRACE_MASKD, string2.substring(n2, n2 + 80));
            n2 += 80;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void subscribeForCIMEvents(SurveillanceEventList surveillanceEventList) {
        String string = null;
        String string2 = null;
        CIMNameSpace cIMNameSpace = null;
        HSCException hSCException = null;
        Trace.trace(TRACE_MASKT, "-> subscribeForCIMEvents()");
        string = SurveillancePartitionStateList._getHostName();
        try {
            cIMNameSpace = new CIMNameSpace(string, "root/ibmhscV3_2");
            string2 = HscPasswordMgr.getPassword("hscroot");
            this.cimomListener = new SurveillanceCimomListener(surveillanceEventList, this);
            this.subscription = HSCSubscriptionMgrFactory.createSubscriptionMgr(string, null, -1, true, -1, null, null);
            Trace.trace(TRACE_MASKD, "created subscription");
            this.lparAddSubscriptionId = this.subscription.subscribe(1, "IBMHSC_Partition", "hscroot", string2, this.cimomListener);
            this.lparDeleteSubscriptionId = this.subscription.subscribe(2, "IBMHSC_Partition", "hscroot", string2, this.cimomListener);
            this.lparModifySubscriptionId = this.subscription.subscribe(4, "IBMHSC_Partition", "hscroot", string2, this.cimomListener);
            this.lparRestoreSubscriptionId = this.subscription.subscribe(16, "IBMHSC_Partition", "hscroot", string2, this.cimomListener);
        }
        catch (HSCException hSCException2) {
            hSCException = hSCException2;
        }
        finally {
            if (hSCException != null) {
                if (this.subscription != null) {
                    this.subscription = null;
                }
                if (this.cimomListener != null) {
                    this.cimomListener = null;
                }
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 6, hSCException).writeEntry(null);
            }
        }
        Trace.trace(TRACE_MASKT, "<- subscribeForCIMEvents()");
    }

    synchronized void unsubscribeForCIMEvents() {
        Trace.trace(TRACE_MASKT, "-> unsubscribeForCIMEvents()");
        if (this.subscription != null) {
            try {
                this.subscription.unsubscribe(this.lparAddSubscriptionId, "hscroot", HscPasswordMgr.getPassword("hscroot"));
            }
            catch (HSCException hSCException) {
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
            }
            try {
                this.subscription.unsubscribe(this.lparDeleteSubscriptionId, "hscroot", HscPasswordMgr.getPassword("hscroot"));
            }
            catch (HSCException hSCException) {
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
            }
            try {
                this.subscription.unsubscribe(this.lparModifySubscriptionId, "hscroot", HscPasswordMgr.getPassword("hscroot"));
            }
            catch (HSCException hSCException) {
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
            }
            try {
                this.subscription.unsubscribe(this.lparRestoreSubscriptionId, "hscroot", HscPasswordMgr.getPassword("hscroot"));
            }
            catch (HSCException hSCException) {
                new AusMicrocodeLog(Surveillance.SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO, 7, hSCException).writeEntry(null);
            }
            try {
                this.subscription.close();
                Trace.trace(TRACE_MASKF, "Successfully closed the CIM subscription manager.");
            }
            catch (HSCException hSCException) {
                Trace.trace(TRACE_MASKF, "Error closing the CIM subscription manager : ");
                Trace.trace(TRACE_MASKF, hSCException);
            }
            this.subscription = null;
        }
        if (this.cimomListener != null) {
            this.cimomListener = null;
        }
        Trace.trace(TRACE_MASKT, "<- unsubscribeForCIMEvents()");
    }

    private static String _getHostName() {
        try {
            String string = InetAddress.getLocalHost().getHostName();
            if (string != null && string.length() > 0) {
                return string;
            }
        }
        catch (Exception exception) {}
        return "localhost";
    }
}

